/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 05/30/2007 : Version 1.0
* Description        : A sample demonstration program  supplied to demonstrate
*                      and test the EEPROM Emulation driver using  3 variables
*                      already defined.
********************************************************************************
* History:
* 05/30/2007 : Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "91x_lib.h"
#include "EEPROM.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/


int i;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

void main(void)
{


#ifdef DEBUG
  debug();
#endif

  
  /* Enable the clock for FMI */
  SCU_AHBPeriphClockConfig(__FMI, ENABLE);
  SCU_AHBPeriphReset(__FMI, DISABLE);


  /* -------------------------------------------------------------------------*/
  /*                Configure bank 0 as 512KB and bank 1 as 32KB              */
  /*        Configure bank 0 at address 0x0 and bank 1 at address 0x80000     */
  /* -------------------------------------------------------------------------*/

  FMI_BankRemapConfig(0x4, 0x2, 0x0, 0x80000);

  /* ------------------------------------------------------------------------ */
  /*       Disable the Write protection for sector0/sector1 of bank 1         */
  /* ------------------------------------------------------------------------ */

  FMI_WriteProtectionCmd(FMI_B1S0, DISABLE);
  FMI_WriteProtectionCmd(FMI_B1S1, DISABLE);


  EepromFormat();


/***************************Test main progrm************************************
The following example shows 3 EEPROM variables with the following virtual
 addresses:
 - var1: AAAAh
 - var2: 5555h
 - var3: DDAAh
We switch automatically to sector1 when there is no enough space on sector0.
The latest update of the other variables is restored in the current sector.
*******************************************************************************/


  for (i = 0; i < 1000; i++)

  {
    WriteVariable(0xAAAA, i);

  }
  for (i = 0; i < 500; i++)

  {
    WriteVariable(0x5555, i);

  }


  for (i = 0; i < 800; i++)

  {
    WriteVariable(0xDDAA, i);

  
  }

}

/******************* (c) 2007  ST Microelectronics *********** END OF FILE ****/
